import { HttpClient } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import {
  IAttribute,
  IAttributeModel,
  IAttributeValueModel,
} from '../interface/attribute.interface';
import { Params } from '../interface/core.interface';

@Injectable({
  providedIn: 'root',
})
export class AttributeService {
  private http = inject(HttpClient);

  getAttributes(payload?: Params): Observable<IAttributeModel> {
    return this.http.get<IAttributeModel>(`${environment.URL}/attribute`, { params: payload });
  }

  getAttributeValues(payload?: Params): Observable<IAttributeValueModel> {
    return this.http.get<IAttributeValueModel>(`${environment.URL}/attribute-value`, {
      params: payload,
    });
  }

  createAttribute(payload: IAttribute): Observable<IAttribute> {
    return this.http.post<IAttribute>(`${environment.URL}/attribute`, payload);
  }

  editAttribute(id: number): Observable<IAttribute> {
    return this.http.get<IAttribute>(`${environment.URL}/attribute/${id}`);
  }

  updateAttribute(id: number, payload: IAttribute): Observable<IAttribute> {
    return this.http.put<IAttribute>(`${environment.URL}/attribute/${id}`, payload);
  }

  updateAttributeStatus(id: number, status: boolean): Observable<IAttribute> {
    return this.http.put<IAttribute>(`${environment.URL}/attribute/${id}/${status}`, {});
  }

  deleteAttribute(id: number): Observable<number> {
    return this.http.delete<number>(`${environment.URL}/attribute/${id}`);
  }

  deleteAllAttribute(ids: number[]): Observable<number> {
    return this.http.post<number>(`${environment.URL}/attribute/deleteAll`, { ids: ids });
  }

  importAttribute(payload: File[]): Observable<IAttribute[]> {
    let form = new FormData();
    if (Array.isArray(payload) && payload.length) {
      payload.forEach((element: File, _index: number) => {
        form.append(`attributes`, element, element.name);
      });
    }
    return this.http.post<IAttribute[]>(`${environment.URL}/attribute/csv/import`, form);
  }

  exportAttribute(): Observable<Blob> {
    const requestBody = {}; // You can provide any necessary request body here
    return this.http.post<Blob>(`${environment.URL}/attribute/csv/export`, requestBody, {
      responseType: 'blob' as 'json',
    });
  }
}
