import { HttpClient } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import {
  IAuthUserForgotModel,
  IAuthUserStateModel,
  IUpdatePasswordModel,
  IVerifyEmailOtpModel,
  IAuthModel,
} from '../interface/auth.interface';

@Injectable({
  providedIn: 'root',
})
export class AuthService {
  private http = inject(HttpClient);

  login(payload: IAuthUserStateModel): Observable<IAuthModel> {
    return this.http.post<IAuthModel>(`${environment.URL}/login`, payload);
  }

  forgotPassword(payload: IAuthUserForgotModel) {
    return this.http.post(`${environment.URL}/forgot-password`, payload);
  }

  verifyEmailOtp(payload: IVerifyEmailOtpModel) {
    return this.http.post(`${environment.URL}/verify-token`, payload);
  }

  updatePassword(payload: IUpdatePasswordModel) {
    return this.http.post(`${environment.URL}/update-password`, payload);
  }

  logout() {
    return this.http.post<string>(`${environment.URL}/logout`, {});
  }
}
