import { HttpClient } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { IAuthor, IAuthorModel } from '../interface/author.interface';
import { Params } from '../interface/core.interface';

@Injectable({
  providedIn: 'root',
})
export class AuthorService {
  private http = inject(HttpClient);

  getAuthors(payload?: Params): Observable<IAuthorModel> {
    return this.http.get<IAuthorModel>(`${environment.URL}/author`, { params: payload });
  }

  createAuthor(payload: IAuthor): Observable<IAuthor> {
    return this.http.post<IAuthor>(`${environment.URL}/author`, payload);
  }

  editAuthor(id: number): Observable<IAuthor> {
    return this.http.get<IAuthor>(`${environment.URL}/author/${id}`);
  }

  updateAuthor(id: number, payload: IAuthor): Observable<IAuthor> {
    return this.http.put<IAuthor>(`${environment.URL}/author/${id}`, payload);
  }

  updateAuthorStatus(id: number, status: boolean): Observable<IAuthor> {
    return this.http.put<IAuthor>(`${environment.URL}/author/${id}/${status}`, {});
  }

  deleteAuthor(id: number): Observable<number> {
    return this.http.delete<number>(`${environment.URL}/author/${id}`);
  }

  deleteAllAuthor(ids: number[]): Observable<number> {
    return this.http.post<number>(`${environment.URL}/author/deleteAll`, { ids: ids });
  }
}
