import { HttpClient } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { IBlog, IBlogModel } from '../interface/blog.interface';
import { Params } from '../interface/core.interface';

@Injectable({
  providedIn: 'root',
})
export class BlogService {
  private http = inject(HttpClient);

  getBlogs(payload?: Params): Observable<IBlogModel> {
    return this.http.get<IBlogModel>(`${environment.URL}/blog`, { params: payload });
  }

  createBlog(payload: IBlog): Observable<IBlog> {
    return this.http.post<IBlog>(`${environment.URL}/blog`, payload);
  }

  editBlog(id: number): Observable<IBlog> {
    return this.http.get<IBlog>(`${environment.URL}/blog/${id}`);
  }

  updateBlog(id: number, payload: IBlog): Observable<IBlog> {
    return this.http.put<IBlog>(`${environment.URL}/blog/${id}`, payload);
  }

  updateBlogStatus(id: number, status: boolean): Observable<IBlog> {
    return this.http.put<IBlog>(`${environment.URL}/blog/${id}/${status}`, {});
  }

  deleteBlog(id: number): Observable<number> {
    return this.http.delete<number>(`${environment.URL}/blog/${id}`);
  }

  deleteAllBlog(ids: number[]): Observable<number> {
    return this.http.post<number>(`${environment.URL}/blog/deleteAll`, { ids: ids });
  }
}
