import { HttpClient } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { IBrand, IBrandModel } from '../interface/brand.interface';
import { Params } from '../interface/core.interface';

@Injectable({
  providedIn: 'root',
})
export class BrandService {
  private http = inject(HttpClient);

  getBrands(payload?: Params): Observable<IBrandModel> {
    return this.http.get<IBrandModel>(`${environment.URL}/brand`, { params: payload });
  }

  createBrand(payload: IBrand): Observable<IBrand> {
    return this.http.post<IBrand>(`${environment.URL}/brand`, payload);
  }

  editBrand(id: number): Observable<IBrand> {
    return this.http.get<IBrand>(`${environment.URL}/brand/${id}`);
  }

  updateBrand(id: number, payload: IBrand): Observable<IBrand> {
    return this.http.put<IBrand>(`${environment.URL}/brand/${id}`, payload);
  }

  updateBrandStatus(id: number, status: boolean): Observable<IBrand> {
    return this.http.put<IBrand>(`${environment.URL}/brand/${id}/${status}`, {});
  }

  deleteBrand(id: number): Observable<number> {
    return this.http.delete<number>(`${environment.URL}/brand/${id}`);
  }

  deleteAllBrand(ids: number[]): Observable<number> {
    return this.http.post<number>(`${environment.URL}/brand/deleteAll`, { ids: ids });
  }

  importBrand(payload: File[]): Observable<IBrand[]> {
    let form = new FormData();
    if (Array.isArray(payload) && payload.length) {
      payload.forEach((element: File, _index: number) => {
        form.append(`brands`, element, element.name);
      });
    }
    return this.http.post<IBrand[]>(`${environment.URL}/brand/csv/import`, form);
  }

  exportBrand(): Observable<Blob> {
    const requestBody = {}; // You can provide any necessary request body here
    return this.http.post<Blob>(`${environment.URL}/brand/csv/export`, requestBody, {
      responseType: 'blob' as 'json',
    });
  }
}
