import { HttpClient } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { ICartModel, ICartAddOrUpdate } from '../interface/cart.interface';

@Injectable({
  providedIn: 'root',
})
export class CartService {
  private http = inject(HttpClient);

  getCartItems(): Observable<ICartModel> {
    return this.http.get<ICartModel>(`${environment.URL}/cart`);
  }

  addToCart(payload: ICartAddOrUpdate): Observable<ICartModel> {
    return this.http.post<ICartModel>(`${environment.URL}/cart`, payload);
  }

  updateCart(payload: ICartAddOrUpdate): Observable<ICartModel> {
    return this.http.put<ICartModel>(`${environment.URL}/cart`, payload);
  }

  deleteCart(id: Number): Observable<number> {
    return this.http.delete<number>(`${environment.URL}/cart/${id}`);
  }
}
