import { HttpClient } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { ICategory, ICategoryModel } from '../interface/category.interface';
import { Params } from '../interface/core.interface';

@Injectable({
  providedIn: 'root',
})
export class CategoryService {
  private http = inject(HttpClient);

  getCategories(payload?: Params): Observable<ICategoryModel> {
    return this.http.get<ICategoryModel>(`${environment.URL}/category`, { params: payload });
  }

  createCategory(payload: ICategory): Observable<ICategory> {
    return this.http.post<ICategory>(`${environment.URL}/category`, payload);
  }

  editCategory(id: number): Observable<ICategory> {
    return this.http.get<ICategory>(`${environment.URL}/category/${id}`);
  }

  updateCategory(id: number, payload: ICategory): Observable<ICategory> {
    return this.http.put<ICategory>(`${environment.URL}/category/${id}`, payload);
  }

  deleteCategory(id: number): Observable<number> {
    return this.http.delete<number>(`${environment.URL}/category/${id}`);
  }

  importCategory(payload: File[]): Observable<ICategory[]> {
    let form = new FormData();
    if (Array.isArray(payload) && payload.length) {
      payload.forEach((element: File, _index: number) => {
        form.append(`categories`, element, element.name);
      });
    }
    return this.http.post<ICategory[]>(`${environment.URL}/category/csv/import`, form);
  }

  exportCategory(): Observable<Blob> {
    const requestBody = {}; // You can provide any necessary request body here
    return this.http.post<Blob>(`${environment.URL}/category/csv/export`, requestBody, {
      responseType: 'blob' as 'json',
    });
  }
}
