import { HttpClient } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { Params } from '../interface/core.interface';
import { ICoupon, ICouponModel } from '../interface/coupon.interface';

@Injectable({
  providedIn: 'root',
})
export class CouponService {
  private http = inject(HttpClient);

  getCoupons(payload?: Params): Observable<ICouponModel> {
    return this.http.get<ICouponModel>(`${environment.URL}/coupon`, { params: payload });
  }

  createCoupon(payload: ICoupon): Observable<ICoupon> {
    return this.http.post<ICoupon>(`${environment.URL}/coupon`, payload);
  }

  editCoupon(id: number): Observable<ICoupon> {
    return this.http.get<ICoupon>(`${environment.URL}/coupon/${id}`);
  }

  updateCoupon(id: number, payload: ICoupon): Observable<ICoupon> {
    return this.http.put<ICoupon>(`${environment.URL}/coupon/${id}`, payload);
  }

  updateCouponStatus(id: number, status: boolean): Observable<ICoupon> {
    return this.http.put<ICoupon>(`${environment.URL}/coupon/${id}/${status}`, {});
  }

  deleteCoupon(id: number): Observable<number> {
    return this.http.delete<number>(`${environment.URL}/coupon/${id}`);
  }

  deleteAllCoupon(ids: number[]): Observable<number> {
    return this.http.post<number>(`${environment.URL}/coupon/deleteAll`, { ids: ids });
  }
}
