import { HttpClient } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { Params } from '../interface/core.interface';
import { ICurrency, ICurrencyModel } from '../interface/currency.interface';

@Injectable({
  providedIn: 'root',
})
export class CurrencyService {
  private http = inject(HttpClient);

  getCurrencies(payload?: Params): Observable<ICurrencyModel> {
    return this.http.get<ICurrencyModel>(`${environment.URL}/currency`, { params: payload });
  }

  createCurrency(payload: ICurrency): Observable<ICurrency> {
    return this.http.post<ICurrency>(`${environment.URL}/currency`, payload);
  }

  editCurrency(id: number): Observable<ICurrency> {
    return this.http.get<ICurrency>(`${environment.URL}/currency/${id}`);
  }

  updateCurrency(id: number, payload: ICurrency): Observable<ICurrency> {
    return this.http.put<ICurrency>(`${environment.URL}/currency/${id}`, payload);
  }

  updateCurrencyStatus(id: number, status: boolean): Observable<ICurrency> {
    return this.http.put<ICurrency>(`${environment.URL}/currency/${id}/${status}`, {});
  }

  deleteCurrency(id: number): Observable<number> {
    return this.http.delete<number>(`${environment.URL}/currency/${id}`);
  }

  deleteAllCurrency(ids: number[]): Observable<number> {
    return this.http.post<number>(`${environment.URL}/currency/deleteAll`, { ids: ids });
  }
}
