import { HttpErrorResponse } from '@angular/common/http';
import { Injectable, PLATFORM_ID, inject } from '@angular/core';

@Injectable({
  providedIn: 'root',
})
export class ErrorService {
  private platformId = inject(PLATFORM_ID);

  getClientErrorMessage(error: Error): string {
    if (navigator) {
      return error.message || 'An unexpected server error occurred';
    }
    return 'An unexpected error occurred';
  }

  getServerErrorMessage(error: HttpErrorResponse): string {
    return error.message;
  }
}
