import { HttpClient } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { Params } from '../interface/core.interface';
import { IFaq, IFaqModel } from '../interface/faq.interface';

@Injectable({
  providedIn: 'root',
})
export class FaqService {
  private http = inject(HttpClient);

  getFaqs(payload?: Params): Observable<IFaqModel> {
    return this.http.get<IFaqModel>(`${environment.URL}/faq`, { params: payload });
  }

  createFaq(payload: IFaq): Observable<IFaq> {
    return this.http.post<IFaq>(`${environment.URL}/faq`, payload);
  }

  editFaq(id: number): Observable<IFaq> {
    return this.http.get<IFaq>(`${environment.URL}/faq/${id}`);
  }

  updateFaq(id: number, payload: IFaq): Observable<IFaq> {
    return this.http.put<IFaq>(`${environment.URL}/faq/${id}`, payload);
  }

  updateFaqStatus(id: number, status: boolean): Observable<IFaq> {
    return this.http.put<IFaq>(`${environment.URL}/faq/${id}/${status}`, {});
  }

  deleteFaq(id: number): Observable<number> {
    return this.http.delete<number>(`${environment.URL}/faq/${id}`);
  }

  deleteAllFaq(ids: number[]): Observable<number> {
    return this.http.post<number>(`${environment.URL}/faq/deleteAll`, { ids: ids });
  }
}
