import { HttpClient } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { Params } from '../interface/core.interface';
import { ILanguage, ILanguageFiledModel, ILanguageModel } from '../interface/language.interface';

@Injectable({
  providedIn: 'root',
})
export class LanguageService {
  private http = inject(HttpClient);

  getLanguage(payload?: Params): Observable<ILanguageModel> {
    return this.http.get<ILanguageModel>(`${environment.URL}/language`, { params: payload });
  }

  createLanguage(payload: ILanguage): Observable<ILanguage> {
    return this.http.post<ILanguage>(`${environment.URL}/language`, payload);
  }

  editLanguage(id: number): Observable<ILanguage> {
    return this.http.get<ILanguage>(`${environment.URL}/language/${id}`);
  }

  updateLanguage(id: number, payload: ILanguage): Observable<ILanguage> {
    return this.http.put<ILanguage>(`${environment.URL}/language/${id}`, payload);
  }

  updateLanguageStatus(id: number, status: boolean): Observable<ILanguage> {
    return this.http.put<ILanguage>(`${environment.URL}/language/${id}/${status}`, {});
  }

  deleteLanguage(id: number): Observable<number> {
    return this.http.delete<number>(`${environment.URL}/language/${id}`);
  }

  getLanguageFiles(): Observable<{ name: string; slug: string }[]> {
    return this.http.get<{ name: string; slug: string }[]>(`${environment.URL}/translation`);
  }

  getLanguageFilesFields(file: string, params?: Params): Observable<ILanguageFiledModel> {
    return this.http.get<ILanguageFiledModel>(`${environment.URL}/translation/${file}`, {
      params: params,
    });
  }

  updateLanguageFilesFields(
    file: string,
    payload?: ILanguage,
    params?: Params,
  ): Observable<ILanguageFiledModel> {
    return this.http.put<ILanguageFiledModel>(`${environment.URL}/translation/${file}`, payload, {
      params: params,
    });
  }
}
