import { HttpClient } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { Params } from '../interface/core.interface';
import { ILicenseKey, ILicenseKeyModel } from '../interface/license-key.interface';

@Injectable({
  providedIn: 'root',
})
export class LicenseKeyService {
  private http = inject(HttpClient);

  getLicenseKeys(payload?: Params): Observable<ILicenseKeyModel> {
    return this.http.get<ILicenseKeyModel>(`${environment.URL}/license-key`, { params: payload });
  }

  createLicenseKey(payload: ILicenseKey): Observable<ILicenseKey> {
    return this.http.post<ILicenseKey>(`${environment.URL}/license-key`, payload);
  }

  editLicenseKey(id: number): Observable<ILicenseKey> {
    return this.http.get<ILicenseKey>(`${environment.URL}/license-key/${id}`);
  }

  updateLicenseKey(id: number, payload: ILicenseKey): Observable<ILicenseKey> {
    return this.http.put<ILicenseKey>(`${environment.URL}/license-key/${id}`, payload);
  }

  updateLicenseKeyStatus(id: number, status: boolean): Observable<ILicenseKey> {
    return this.http.put<ILicenseKey>(`${environment.URL}/license-key/${id}/${status}`, {});
  }

  deleteLicenseKey(id: number): Observable<number> {
    return this.http.delete<number>(`${environment.URL}/license-key/${id}`);
  }

  deleteAllLicenseKey(ids: number[]): Observable<number> {
    return this.http.post<number>(`${environment.URL}/license-key/deleteAll`, { ids: ids });
  }
}
