import { HttpClient } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';
import { Params } from '@angular/router';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { IMenu, IMenuModel } from '../interface/menu.interface';

@Injectable({
  providedIn: 'root',
})
export class MenuService {
  private http = inject(HttpClient);

  getMenu(payload?: Params): Observable<IMenuModel> {
    return this.http.get<IMenuModel>(`${environment.URL}/menu`, { params: payload });
  }

  createMenu(payload: IMenu): Observable<IMenu> {
    return this.http.post<IMenu>(`${environment.URL}/menu`, payload);
  }

  editMenu(id: number): Observable<IMenu> {
    return this.http.get<IMenu>(`${environment.URL}/menu/${id}`);
  }

  updateMenu(id: number, payload: IMenu): Observable<IMenu> {
    return this.http.put<IMenu>(`${environment.URL}/menu/${id}`, payload);
  }

  updateSortMenu(payload: Params): Observable<IMenuModel> {
    return this.http.post<IMenuModel>(`${environment.URL}/menu/sort`, payload);
  }

  deleteMenu(id: number): Observable<number> {
    return this.http.delete<number>(`${environment.URL}/menu/${id}`);
  }
}
