import { HttpClient } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { Params } from '../interface/core.interface';
import { INotice, INoticeModel } from '../interface/notice.interface';

@Injectable({
  providedIn: 'root',
})
export class NoticeService {
  private http = inject(HttpClient);

  getNotice(payload?: Params): Observable<INoticeModel> {
    return this.http.get<INoticeModel>(`${environment.URL}/notice`, { params: payload });
  }

  createNotice(payload: INotice): Observable<INotice> {
    return this.http.post<INotice>(`${environment.URL}/notice`, payload);
  }

  editNotice(id: number | string): Observable<INotice> {
    return this.http.get<INotice>(`${environment.URL}/notice/${id}`);
  }

  updateNotice(id: number, payload: INotice): Observable<INotice> {
    return this.http.put<INotice>(`${environment.URL}/notice/${id}`, payload);
  }

  markAsRead(id: number): Observable<INotice> {
    return this.http.put<INotice>(`${environment.URL}/notice/markAsRead/${id}`, {});
  }

  deleteNotice(id: number): Observable<number> {
    return this.http.delete<number>(`${environment.URL}/notice/${id}`);
  }
}
