import { HttpClient } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { Params } from '../interface/core.interface';
import {
  ICheckoutPayload,
  IOrder,
  IOrderCheckout,
  IOrderModel,
} from '../interface/order.interface';

@Injectable({
  providedIn: 'root',
})
export class OrderService {
  private http = inject(HttpClient);

  getOrders(payload?: Params): Observable<IOrderModel> {
    return this.http.get<IOrderModel>(`${environment.URL}/order`, { params: payload });
  }

  viewOrder(id: number): Observable<IOrder> {
    return this.http.get<IOrder>(`${environment.URL}/order/${id}`);
  }

  checkout(payload: ICheckoutPayload): Observable<IOrderCheckout> {
    return this.http.post<IOrderCheckout>(`${environment.URL}/checkout`, payload);
  }

  placeOrder(payload: ICheckoutPayload): Observable<IOrder> {
    return this.http.post<IOrder>(`${environment.URL}/order`, payload);
  }

  updateOrderStatus(
    id: number,
    payload: { order_status_id: number; note: string },
  ): Observable<IOrder> {
    return this.http.put<IOrder>(`${environment.URL}/order/${id}`, payload);
  }

  downloadInvoice(payload?: Params): Observable<Blob> {
    return this.http.post<Blob>(`${environment.URL}/order/invoice`, payload, {
      responseType: 'blob' as 'json',
    });
  }
}
