import { HttpClient } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { Params } from '../interface/core.interface';
import { IPage, IPageModel } from '../interface/page.interface';

@Injectable({
  providedIn: 'root',
})
export class PageService {
  private http = inject(HttpClient);

  getPages(payload?: Params): Observable<IPageModel> {
    return this.http.get<IPageModel>(`${environment.URL}/page`, { params: payload });
  }

  createPage(payload: IPage): Observable<IPage> {
    return this.http.post<IPage>(`${environment.URL}/page`, payload);
  }

  editPage(id: number): Observable<IPage> {
    return this.http.get<IPage>(`${environment.URL}/page/${id}`);
  }

  updatePage(id: number, payload: IPage): Observable<IPage> {
    return this.http.put<IPage>(`${environment.URL}/page/${id}`, payload);
  }

  updatePageStatus(id: number, status: boolean): Observable<IPage> {
    return this.http.put<IPage>(`${environment.URL}/page/${id}/${status}`, {});
  }

  deletePage(id: number): Observable<number> {
    return this.http.delete<number>(`${environment.URL}/page/${id}`);
  }

  deleteAllPage(ids: number[]): Observable<number> {
    return this.http.post<number>(`${environment.URL}/page/deleteAll`, { ids: ids });
  }
}
