import { HttpClient } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { Params } from '../interface/core.interface';
import { IPublication, IPublicationModel } from '../interface/publication.interface';

@Injectable({
  providedIn: 'root',
})
export class PublicationService {
  private http = inject(HttpClient);

  getPublications(payload?: Params): Observable<IPublicationModel> {
    return this.http.get<IPublicationModel>(`${environment.URL}/publication`, { params: payload });
  }

  createPublication(payload: IPublication): Observable<IPublication> {
    return this.http.post<IPublication>(`${environment.URL}/publication`, payload);
  }

  editPublication(id: number): Observable<IPublication> {
    return this.http.get<IPublication>(`${environment.URL}/publication/${id}`);
  }

  updatePublication(id: number, payload: IPublication): Observable<IPublication> {
    return this.http.put<IPublication>(`${environment.URL}/publication/${id}`, payload);
  }

  updatePublicationStatus(id: number, status: boolean): Observable<IPublication> {
    return this.http.put<IPublication>(`${environment.URL}/publication/${id}/${status}`, {});
  }

  deletePublication(id: number): Observable<number> {
    return this.http.delete<number>(`${environment.URL}/publication/${id}`);
  }

  deleteAllPublication(ids: number[]): Observable<number> {
    return this.http.post<number>(`${environment.URL}/publication/deleteAll`, { ids: ids });
  }
}
