import { HttpClient } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { Params } from '../interface/core.interface';
import { IQnAModel, IQuestionAnswers } from '../interface/questions-answers.interface';

@Injectable({
  providedIn: 'root',
})
export class QuestionsAnswersService {
  private http = inject(HttpClient);

  getQuestionAnswers(payload?: Params): Observable<IQnAModel> {
    return this.http.get<IQnAModel>(`${environment.URL}/question-and-answer`, { params: payload });
  }

  editQuestionAnswers(id: number): Observable<IQuestionAnswers> {
    return this.http.get<IQuestionAnswers>(`${environment.URL}/question-and-answer/${id}`);
  }

  updateQuestionAnswers(id: number, payload: Params): Observable<IQuestionAnswers> {
    return this.http.put<IQuestionAnswers>(`${environment.URL}/question-and-answer/${id}`, payload);
  }

  deleteQuestionAnswers(id: number): Observable<number> {
    return this.http.delete<number>(`${environment.URL}/question-and-answer/${id}`);
  }

  deleteAllQuestionAnswers(ids: number[]): Observable<number> {
    return this.http.post<number>(`${environment.URL}/question-and-answer/deleteAll`, { ids: ids });
  }
}
