import { HttpClient } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { Params } from '../interface/core.interface';
import { IRefund, IRefundModel } from '../interface/refund.interface';

@Injectable({
  providedIn: 'root',
})
export class RefundService {
  private http = inject(HttpClient);

  getRefunds(payload?: Params): Observable<IRefundModel> {
    return this.http.get<IRefundModel>(`${environment.URL}/refund`, { params: payload });
  }

  updaterefundStatus(id: number, status: string): Observable<IRefund> {
    return this.http.put<IRefund>(`${environment.URL}/refund/${id}`, { status: status });
  }
}
