import { HttpClient } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { Params } from '../interface/core.interface';

@Injectable({
  providedIn: 'root',
})
export class ReportsService {
  private http = inject(HttpClient);

  getReportsTypes(): Observable<any> {
    return this.http.get<any>(`${environment.URL}/reports`);
  }

  getReportsFields(filed: string): Observable<any> {
    return this.http.get<any>(`${environment.URL}/reports/fields/${filed}`);
  }

  getReports(report: string, payload?: Params): Observable<any> {
    return this.http.get<any>(`${environment.URL}/reports/${report}`, { params: payload });
  }

  getProductSaleReports(type: string, payload?: Params): Observable<any> {
    return this.http.get<any>(`${environment.URL}/reports/${type}`, { params: payload });
  }

  getVendorProductSaleReports(payload?: Params): Observable<any> {
    return this.http.get<any>(`${environment.URL}/reports/vendor-product-sale`, {
      params: payload,
    });
  }

  getWishlistReports(payload?: Params): Observable<any> {
    return this.http.get<any>(`${environment.URL}/reports/wishlist`, { params: payload });
  }

  getCartReports(payload?: Params): Observable<any> {
    return this.http.get<any>(`${environment.URL}/reports/cart`, { params: payload });
  }

  getCategorySaleReports(payload?: Params): Observable<any> {
    return this.http.get<any>(`${environment.URL}/reports/category-sale`, { params: payload });
  }

  getProductsReports(payload?: Params): Observable<any> {
    // in-stock
    // out-of-stock
    // top-selling
    return this.http.get<any>(`${environment.URL}/reports/products/in-stock`, { params: payload });
  }

  getBrandsOrderReports(payload?: Params): Observable<any> {
    return this.http.get<any>(`${environment.URL}/reports/customers/brands/top-orders`, {
      params: payload,
    });
  }

  getPaymentGetewayReports(payload?: Params): Observable<any> {
    return this.http.get<any>(`${environment.URL}/reports/payment-gateways`, { params: payload });
  }
}
