import { HttpClient } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { Params } from '../interface/core.interface';
import { IReviewModel } from '../interface/review.interface';

@Injectable({
  providedIn: 'root',
})
export class ReviewService {
  private http = inject(HttpClient);

  getReviews(payload?: Params): Observable<IReviewModel> {
    return this.http.get<IReviewModel>(`${environment.URL}/review`, { params: payload });
  }

  deleteReview(id: number): Observable<number> {
    return this.http.delete<number>(`${environment.URL}/review/${id}`);
  }

  deleteAllReview(ids: number[]): Observable<number> {
    return this.http.post<number>(`${environment.URL}/review/deleteAll`, { ids: ids });
  }
}
