import { HttpClient } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { Params } from '../interface/core.interface';
import { IRole, IRoleModel, IModule } from '../interface/role.interface';

@Injectable({
  providedIn: 'root',
})
export class RoleService {
  private http = inject(HttpClient);

  getRoleModules(): Observable<IModule[]> {
    return this.http.get<IModule[]>(`${environment.URL}/module`);
  }

  getRoles(payload?: Params): Observable<IRoleModel> {
    return this.http.get<IRoleModel>(`${environment.URL}/role`, { params: payload });
  }

  createRole(payload: IRole): Observable<IRole> {
    return this.http.post<IRole>(`${environment.URL}/role`, payload);
  }

  editRole(id: number): Observable<IRole> {
    return this.http.get<IRole>(`${environment.URL}/role/${id}`);
  }

  updateRole(id: number, payload: IRole): Observable<IRole> {
    return this.http.put<IRole>(`${environment.URL}/role/${id}`, payload);
  }

  deleteRole(id: number): Observable<number> {
    return this.http.delete<number>(`${environment.URL}/role/${id}`);
  }

  deleteAllRole(ids: number[]): Observable<number> {
    return this.http.post<number>(`${environment.URL}/role/deleteAll`, { ids: ids });
  }
}
