import { HttpClient } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { Params } from '../interface/core.interface';
import { IAppSetting, IGoogleReCaptcha, ISetting } from '../interface/setting.interface';

@Injectable({
  providedIn: 'root',
})
export class SettingService {
  private http = inject(HttpClient);

  reCaptchaConfig: IGoogleReCaptcha;

  getSettingOption(): Observable<ISetting> {
    return this.http.get<ISetting>(`${environment.URL}/settings`);
  }

  updateSettingOption(payload: Params): Observable<ISetting> {
    return this.http.put<ISetting>(`${environment.URL}/settings`, payload);
  }

  testMail(payload: Params): Observable<ISetting> {
    return this.http.post<ISetting>(`${environment.URL}/notifications/test`, payload);
  }

  getAppSettingOption(): Observable<IAppSetting> {
    return this.http.get<IAppSetting>(`${environment.URL}/app/settings`);
  }

  updateAppSettingOption(payload: Params): Observable<IAppSetting> {
    return this.http.put<IAppSetting>(`${environment.URL}/app/settings`, payload);
  }

  async getReCaptchaConfig(): Promise<void> {
    const config = await this.getSettingOption().toPromise();
    this.reCaptchaConfig = config?.values?.google_reCaptcha!;
  }
}
