import { HttpClient } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { Params } from '../interface/core.interface';
import { IShipping, IShippingRule } from '../interface/shipping.interface';

@Injectable({
  providedIn: 'root',
})
export class ShippingService {
  private http = inject(HttpClient);

  getShippings(payload?: Params): Observable<IShipping[]> {
    return this.http.get<IShipping[]>(`${environment.URL}/shipping`, { params: payload });
  }

  createShipping(payload: IShipping): Observable<IShipping[]> {
    return this.http.post<IShipping[]>(`${environment.URL}/shipping`, payload);
  }

  editShipping(id: number): Observable<IShipping> {
    return this.http.get<IShipping>(`${environment.URL}/shipping/${id}`);
  }

  updateShipping(id: number, payload: IShipping): Observable<IShipping> {
    return this.http.put<IShipping>(`${environment.URL}/shipping/${id}`, payload);
  }

  deleteShipping(id: number): Observable<number> {
    return this.http.delete<number>(`${environment.URL}/shipping/${id}`);
  }

  // For Shipping Rule

  createShippingRule(payload: IShippingRule): Observable<IShippingRule> {
    return this.http.post<IShippingRule>(`${environment.URL}/shippingRule`, payload);
  }

  editShippingRule(id: number): Observable<IShippingRule> {
    return this.http.get<IShippingRule>(`${environment.URL}/shippingRule/${id}`);
  }

  updateShippingRule(id: number, payload: IShippingRule): Observable<IShippingRule> {
    return this.http.put<IShippingRule>(`${environment.URL}/shippingRule/${id}`, payload);
  }

  deleteShippingRule(id: number): Observable<number> {
    return this.http.delete<number>(`${environment.URL}/shippingRule/${id}`);
  }
}
