import { HttpClient } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { Params } from '../interface/core.interface';
import { IStores, IStoresModel } from '../interface/store.interface';

@Injectable({
  providedIn: 'root',
})
export class StoreService {
  private http = inject(HttpClient);

  getStores(payload?: Params): Observable<IStoresModel> {
    return this.http.get<IStoresModel>(`${environment.URL}/store`, { params: payload });
  }

  createStore(payload: IStores): Observable<IStores> {
    return this.http.post<IStores>(`${environment.URL}/store`, payload);
  }

  editStore(id: number): Observable<IStores> {
    return this.http.get<IStores>(`${environment.URL}/store/${id}`);
  }

  updateStore(id: number, payload: IStores): Observable<IStores> {
    return this.http.put<IStores>(`${environment.URL}/store/${id}`, payload);
  }

  updateStoreStatus(id: number, status: boolean): Observable<IStores> {
    return this.http.put<IStores>(`${environment.URL}/store/${id}/${status}`, {});
  }

  approveStoreStatus(id: number, status: boolean): Observable<IStores> {
    return this.http.put<IStores>(`${environment.URL}/store/approve/${id}/${status}`, {});
  }

  deleteStore(id: number): Observable<number> {
    return this.http.delete<number>(`${environment.URL}/store/${id}`);
  }

  deleteAllStore(ids: number[]): Observable<number> {
    return this.http.post<number>(`${environment.URL}/store/deleteAll`, { ids: ids });
  }
}
