import { HttpClient } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { Params } from '../interface/core.interface';
import { ITag, ITagModel } from '../interface/tag.interface';

@Injectable({
  providedIn: 'root',
})
export class TagService {
  private http = inject(HttpClient);

  getTags(payload?: Params): Observable<ITagModel> {
    return this.http.get<ITagModel>(`${environment.URL}/tag`, { params: payload });
  }

  createTag(payload: ITag): Observable<ITag> {
    return this.http.post<ITag>(`${environment.URL}/tag`, payload);
  }

  editTag(id: number): Observable<ITag> {
    return this.http.get<ITag>(`${environment.URL}/tag/${id}`);
  }

  updateTag(id: number, payload: ITag): Observable<ITag> {
    return this.http.put<ITag>(`${environment.URL}/tag/${id}`, payload);
  }

  updateTagStatus(id: number, status: boolean): Observable<ITag> {
    return this.http.put<ITag>(`${environment.URL}/tag/${id}/${status}`, {});
  }

  deleteTag(id: number): Observable<number> {
    return this.http.delete<number>(`${environment.URL}/tag/${id}`);
  }

  deleteAllTag(ids: number[]): Observable<number> {
    return this.http.post<number>(`${environment.URL}/tag/deleteAll`, { ids: ids });
  }

  importTag(payload: File[]): Observable<ITag[]> {
    let form = new FormData();
    if (Array.isArray(payload) && payload.length) {
      payload.forEach((element: File, _index: number) => {
        form.append(`tags`, element, element.name);
      });
    }
    return this.http.post<ITag[]>(`${environment.URL}/tag/csv/import`, form);
  }

  exportTag(): Observable<Blob> {
    const requestBody = {}; // You can provide any necessary request body here
    return this.http.post<Blob>(`${environment.URL}/tag/csv/export`, requestBody, {
      responseType: 'blob' as 'json',
    });
  }
}
