import { HttpClient } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { Params } from '../interface/core.interface';
import { ITax, ITaxModel } from '../interface/tax.interface';

@Injectable({
  providedIn: 'root',
})
export class TaxService {
  private http = inject(HttpClient);

  getTaxes(payload?: Params): Observable<ITaxModel> {
    return this.http.get<ITaxModel>(`${environment.URL}/tax`, { params: payload });
  }

  createTax(payload: ITax): Observable<ITax> {
    return this.http.post<ITax>(`${environment.URL}/tax`, payload);
  }

  editTax(id: number): Observable<ITax> {
    return this.http.get<ITax>(`${environment.URL}/tax/${id}`);
  }

  updateTax(id: number, payload: ITax): Observable<ITax> {
    return this.http.put<ITax>(`${environment.URL}/tax/${id}`, payload);
  }

  updateTaxStatus(id: number, status: boolean): Observable<ITax> {
    return this.http.put<ITax>(`${environment.URL}/tax/${id}/${status}`, {});
  }

  deleteTax(id: number): Observable<number> {
    return this.http.delete<number>(`${environment.URL}/tax/${id}`);
  }

  deleteAllTax(ids: number[]): Observable<number> {
    return this.http.post<number>(`${environment.URL}/tax/deleteAll`, { ids: ids });
  }
}
