import { HttpClient } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { Params } from '../interface/core.interface';
import { IThemeOption } from '../interface/theme-option.interface';

@Injectable({
  providedIn: 'root',
})
export class ThemeOptionService {
  private http = inject(HttpClient);

  getThemeOption(): Observable<IThemeOption> {
    return this.http.get<IThemeOption>(`${environment.URL}/themeOptions`);
  }

  updateThemeOption(payload: Params): Observable<IThemeOption> {
    return this.http.put<IThemeOption>(`${environment.URL}/themeOptions`, payload);
  }
}
