import { HttpClient } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { Params } from '../interface/core.interface';
import { IThemes, IThemesModel } from '../interface/theme.interface';

@Injectable({
  providedIn: 'root',
})
export class ThemeService {
  private http = inject(HttpClient);

  getThemes(): Observable<IThemesModel> {
    return this.http.get<IThemesModel>(`${environment.URL}/theme`);
  }

  updateTheme(id: number, status: number | boolean): Observable<IThemes> {
    return this.http.put<IThemes>(`${environment.URL}/theme/${id}`, { status: status });
  }

  getHomePage(payload?: Params): Observable<IThemes> {
    const requestOptions = {
      params: payload,
    };
    return this.http.get<IThemes>(`${environment.URL}/home`, requestOptions);
  }

  updateHomePage(id: number, payload: Params) {
    return this.http.put(`${environment.URL}/home/${id}`, payload);
  }
}
