import { HttpClient } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';

import { TranslateLoader } from '@ngx-translate/core';
import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { IValues } from '../interface/setting.interface';
import { SettingState } from '../state/setting.state';

export type TranslationMap = Record<string, string>;

@Injectable({
  providedIn: 'root', // or use providedIn: AppModule if only needed in AppModule
})
export class TranslationLoader implements TranslateLoader {
  private http = inject(HttpClient);

  public lang: string;

  setting$: Observable<IValues> = inject(Store).select(SettingState.setting) as Observable<IValues>;

  getTranslation(): Observable<TranslationMap> {
    // Pass headers in the HTTP GET request
    return this.http.get<TranslationMap>(`${environment.URLFront}/translation/admin`);
  }
}
