import { HttpClient } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { Params } from '../interface/core.interface';
import { IUser, IUserAddress, IUserModel } from '../interface/user.interface';

@Injectable({
  providedIn: 'root',
})
export class UserService {
  private http = inject(HttpClient);

  getUsers(payload?: Params): Observable<IUserModel> {
    return this.http.get<IUserModel>(`${environment.URL}/user`, { params: payload });
  }

  createUser(payload: IUser): Observable<IUser> {
    return this.http.post<IUser>(`${environment.URL}/user`, payload);
  }

  editUser(id: number): Observable<IUser> {
    return this.http.get<IUser>(`${environment.URL}/user/${id}`);
  }

  updateUser(id: number, payload: IUser): Observable<IUser> {
    return this.http.put<IUser>(`${environment.URL}/user/${id}`, payload);
  }

  updateUserStatus(id: number, status: boolean): Observable<IUser> {
    return this.http.put<IUser>(`${environment.URL}/user/${id}/${status}`, {});
  }

  deleteUser(id: number): Observable<number> {
    return this.http.delete<number>(`${environment.URL}/user/${id}`);
  }

  deleteAllUser(ids: number[]): Observable<number> {
    return this.http.post<number>(`${environment.URL}/user/deleteAll`, { ids: ids });
  }

  exportUser(): Observable<Blob> {
    const requestBody = {}; // You can provide any necessary request body here
    return this.http.post<Blob>(`${environment.URL}/user/csv/export`, requestBody, {
      responseType: 'blob' as 'json',
    });
  }

  importUser(payload: File[]): Observable<IUser[]> {
    let form = new FormData();
    if (Array.isArray(payload) && payload.length) {
      payload.forEach((element: File, _index: number) => {
        form.append(`users`, element, element.name);
      });
    }
    return this.http.post<IUser[]>(`${environment.URL}/user/csv/import`, form);
  }

  createUserAddress(payload: IUserAddress): Observable<IUser> {
    return this.http.post<IUser>(`${environment.URL}/address`, payload);
  }
}
