import { HttpClient } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { Params } from '../interface/core.interface';
import { ITransactionsPayload, IVenderWallet } from '../interface/vendor-wallet.interface';

@Injectable({
  providedIn: 'root',
})
export class VendorWalletService {
  private http = inject(HttpClient);

  getVendorTransaction(payload?: Params): Observable<IVenderWallet> {
    return this.http.get<IVenderWallet>(`${environment.URL}/wallet/vendor`, { params: payload });
  }

  credit(payload: ITransactionsPayload): Observable<IVenderWallet> {
    return this.http.post<IVenderWallet>(`${environment.URL}/credit/vendorWallet`, payload);
  }

  debit(payload: ITransactionsPayload): Observable<IVenderWallet> {
    return this.http.post<IVenderWallet>(`${environment.URL}/debit/vendorWallet`, payload);
  }
}
