import { HttpClient } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { Params } from '../interface/core.interface';
import { IWithdrawal, IWithdrawalModel } from '../interface/withdrawal.interface';

@Injectable({
  providedIn: 'root',
})
export class WithdrawalService {
  private http = inject(HttpClient);

  getWithdrawRequest(payload?: Params): Observable<IWithdrawalModel> {
    return this.http.get<IWithdrawalModel>(`${environment.URL}/withdrawRequest`, {
      params: payload,
    });
  }

  updateWithdrawStatus(id: number, status: boolean): Observable<IWithdrawal> {
    return this.http.put<IWithdrawal>(`${environment.URL}/withdrawRequest/${id}`, {
      status: status,
    });
  }

  withdrawRequest(payload: Params): Observable<IWithdrawal> {
    return this.http.post<IWithdrawal>(`${environment.URL}/withdrawRequest`, payload);
  }
}
