import { HttpClient } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';

import { Observable } from 'rxjs';

import { environment } from '../../../environments/environment';
import { Params } from '../interface/core.interface';
import { IZone, IZoneModel } from '../interface/zone.interface';

@Injectable({
  providedIn: 'root',
})
export class ZoneService {
  private http = inject(HttpClient);

  getZones(payload?: Params): Observable<IZoneModel> {
    return this.http.get<IZoneModel>(`${environment.URL}/zone`, { params: payload });
  }

  createZone(payload: IZone): Observable<IZone> {
    return this.http.post<IZone>(`${environment.URL}/zone`, payload);
  }

  editZone(id: number): Observable<IZone> {
    return this.http.get<IZone>(`${environment.URL}/zone/${id}`);
  }

  updateZone(id: number, payload: IZone): Observable<IZone> {
    return this.http.put<IZone>(`${environment.URL}/zone/${id}`, payload);
  }

  updateZoneStatus(id: number, status: boolean): Observable<IZone> {
    return this.http.put<IZone>(`${environment.URL}/zone/${id}/${status}`, {});
  }

  deleteZone(id: number): Observable<number> {
    return this.http.delete<number>(`${environment.URL}/zone/${id}`);
  }

  deleteAllZone(ids: number[]): Observable<number> {
    return this.http.post<number>(`${environment.URL}/zone/deleteAll`, { ids: ids });
  }
}
