<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('brands', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable();
            $table->string('slug')->nullable();
            $table->string('meta_title')->nullable();
            $table->longText('meta_description')->nullable();
            $table->unsignedBigInteger('brand_image_id')->nullable();
            $table->unsignedBigInteger('brand_meta_image_id')->nullable();
            $table->unsignedBigInteger('brand_banner_id')->nullable();
            $table->unsignedBigInteger('created_by_id')->nullable();
            $table->integer('status')->default(1);
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('brand_image_id')->references('id')->on('attachments')->onDelete('cascade');
            $table->foreign('brand_meta_image_id')->references('id')->on('attachments')->onDelete('cascade');
            $table->foreign('brand_banner_id')->references('id')->on('attachments')->onDelete('cascade');
            $table->foreign('created_by_id')->references('id')->on('users')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('brands');
    }
};
