<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the default error messages used by
    | the validator class. Some of these rules have multiple versions such
    | as the size rules. Feel free to tweak each of these messages here.
    |
    */

    'accepted' => 'The :attribute must be accepted.',
    'accepted_if' => 'The :attribute must be accepted when :other is :value.',
    'active_url' => 'The :attribute is not a valid URL.',
    'after' => 'The :attribute must be a date after :date.',
    'after_or_equal' => 'The :attribute must be a date after or equal to :date.',
    'alpha' => 'The :attribute must only contain letters.',
    'alpha_dash' => 'The :attribute must only contain letters, numbers, dashes and underscores.',
    'alpha_num' => 'The :attribute must only contain letters and numbers.',
    'array' => 'The :attribute must be an array.',
    'before' => 'The :attribute must be a date before :date.',
    'before_or_equal' => 'The :attribute must be a date before or equal to :date.',
    'between' => [
        'array' => 'The :attribute must have between :min and :max items.',
        'file' => 'The :attribute must be between :min and :max kilobytes.',
        'numeric' => 'The :attribute must be between :min and :max.',
        'string' => 'The :attribute must be between :min and :max characters.',
    ],
    'boolean' => 'The :attribute field must be true or false.',
    'confirmed' => 'The :attribute confirmation does not match.',
    'current_password' => 'The password is incorrect.',
    'date' => 'The :attribute is not a valid date.',
    'date_equals' => 'The :attribute must be a date equal to :date.',
    'date_format' => 'The :attribute does not match the format :format.',
    'declined' => 'The :attribute must be declined.',
    'declined_if' => 'The :attribute must be declined when :other is :value.',
    'different' => 'The :attribute and :other must be different.',
    'digits' => 'The :attribute must be :digits digits.',
    'digits_between' => 'The :attribute must be between :min and :max digits.',
    'dimensions' => 'The :attribute has invalid image dimensions.',
    'distinct' => 'The :attribute field has a duplicate value.',
    'doesnt_end_with' => 'The :attribute may not end with one of the following: :values.',
    'doesnt_start_with' => 'The :attribute may not start with one of the following: :values.',
    'email' => 'The :attribute must be a valid email address.',
    'ends_with' => 'The :attribute must end with one of the following: :values.',
    'enum' => 'The selected :attribute is invalid.',
    'exists' => 'The selected :attribute is invalid.',
    'file' => 'The :attribute must be a file.',
    'filled' => 'The :attribute field must have a value.',
    'gt' => [
        'array' => 'The :attribute must have more than :value items.',
        'file' => 'The :attribute must be greater than :value kilobytes.',
        'numeric' => 'The :attribute must be greater than :value.',
        'string' => 'The :attribute must be greater than :value characters.',
    ],
    'gte' => [
        'array' => 'The :attribute must have :value items or more.',
        'file' => 'The :attribute must be greater than or equal to :value kilobytes.',
        'numeric' => 'The :attribute must be greater than or equal to :value.',
        'string' => 'The :attribute must be greater than or equal to :value characters.',
    ],
    'image' => 'The :attribute must be an image.',
    'in' => 'The selected :attribute is invalid.',
    'in_array' => 'The :attribute field does not exist in :other.',
    'integer' => 'The :attribute must be an integer.',
    'ip' => 'The :attribute must be a valid IP address.',
    'ipv4' => 'The :attribute must be a valid IPv4 address.',
    'ipv6' => 'The :attribute must be a valid IPv6 address.',
    'json' => 'The :attribute must be a valid JSON string.',
    'lt' => [
        'array' => 'The :attribute must have less than :value items.',
        'file' => 'The :attribute must be less than :value kilobytes.',
        'numeric' => 'The :attribute must be less than :value.',
        'string' => 'The :attribute must be less than :value characters.',
    ],
    'lte' => [
        'array' => 'The :attribute must not have more than :value items.',
        'file' => 'The :attribute must be less than or equal to :value kilobytes.',
        'numeric' => 'The :attribute must be less than or equal to :value.',
        'string' => 'The :attribute must be less than or equal to :value characters.',
    ],
    'mac_address' => 'The :attribute must be a valid MAC address.',
    'max' => [
        'array' => 'The :attribute must not have more than :max items.',
        'file' => 'The :attribute must not be greater than :max kilobytes.',
        'numeric' => 'The :attribute must not be greater than :max.',
        'string' => 'The :attribute must not be greater than :max characters.',
    ],
    'max_digits' => 'The :attribute must not have more than :max digits.',
    'mimes' => 'The :attribute must be a file of type: :values.',
    'mimetypes' => 'The :attribute must be a file of type: :values.',
    'min' => [
        'array' => 'The :attribute must have at least :min items.',
        'file' => 'The :attribute must be at least :min kilobytes.',
        'numeric' => 'The :attribute must be at least :min.',
        'string' => 'The :attribute must be at least :min characters.',
    ],
    'min_digits' => 'The :attribute must have at least :min digits.',
    'multiple_of' => 'The :attribute must be a multiple of :value.',
    'not_in' => 'The selected :attribute is invalid.',
    'not_regex' => 'The :attribute format is invalid.',
    'numeric' => 'The :attribute must be a number.',
    'password' => [
        'letters' => 'The :attribute must contain at least one letter.',
        'mixed' => 'The :attribute must contain at least one uppercase and one lowercase letter.',
        'numbers' => 'The :attribute must contain at least one number.',
        'symbols' => 'The :attribute must contain at least one symbol.',
        'uncompromised' => 'The given :attribute has appeared in a data leak. Please choose a different :attribute.',
    ],
    'present' => 'The :attribute field must be present.',
    'prohibited' => 'The :attribute field is prohibited.',
    'prohibited_if' => 'The :attribute field is prohibited when :other is :value.',
    'prohibited_unless' => 'The :attribute field is prohibited unless :other is in :values.',
    'prohibits' => 'The :attribute field prohibits :other from being present.',
    'regex' => 'The :attribute format is invalid.',
    'required' => 'The :attribute field is required.',
    'required_array_keys' => 'The :attribute field must contain entries for: :values.',
    'required_if' => 'The :attribute field is required when :other is :value.',
    'required_unless' => 'The :attribute field is required unless :other is in :values.',
    'required_with' => 'The :attribute field is required when :values is present.',
    'required_with_all' => 'The :attribute field is required when :values are present.',
    'required_without' => 'The :attribute field is required when :values is not present.',
    'required_without_all' => 'The :attribute field is required when none of :values are present.',
    'same' => 'The :attribute and :other must match.',
    'size' => [
        'array' => 'The :attribute must contain :size items.',
        'file' => 'The :attribute must be :size kilobytes.',
        'numeric' => 'The :attribute must be :size.',
        'string' => 'The :attribute must be :size characters.',
    ],
    'starts_with' => 'The :attribute must start with one of the following: :values.',
    'string' => 'The :attribute must be a string.',
    'timezone' => 'The :attribute must be a valid timezone.',
    'unique' => 'The :attribute has already been taken.',
    'uploaded' => 'The :attribute failed to upload.',
    'url' => 'The :attribute must be a valid URL.',
    'uuid' => 'The :attribute must be a valid UUID.',
    'coupon_exists' => 'We could not find an :coupon coupon.',
    'shipping_address_required' => 'The shipping address field is required for guest checkout.',
    'billing_address_required' => 'The billing address field is required for guest checkout.',
    'commission_rate_between' => 'Enter commission rate percentage between 0 to 99.99',
    'category_type_post_or_product' => 'Category type can be either post or product',
    'amount_percent_between' => 'Enter amount percentage between 0 to 99.99',
    'coupon_type_free_shipping_or_fixed_percente' => 'Coupon type can be free_shipping or fixed or percentage',
    'unique_currency' => 'Currency has been already been taken',
    'position_before_or_after_price' => 'Symbol Position can be either before_price or after_price',
    'thousands_separator' => 'Thousands Separator can be either comma, period or space',
    'decimal_separator' => 'Decimal Separator can be either comma, period or space',
    'license_separator' => 'Separator can be new_line or double_new_line or comma or semicolon or pipe',
    'license_already_taken' => 'The license keys has already been taken.',
    'guest_create_account_required' => 'The create account field is required for guest checkout.',
    'guest_checkout_name_required' => 'The name field is required for guest checkout.',
    'guest_email_required' => 'The email field is required for guest checkout.',
    'guest_country_code_required' => 'The country code field is required for guest checkout.',
    'guest_phone_field_required' => 'The phone field is required for guest checkout.',
    'guest_shipping_address_required' => 'The shipping address field is required for guest checkout.',
    'guest_billing_address_required' => 'The billing address field is required for guest checkout.',
    'discount_between' => 'Enter discount between 0 to 99.99',
    'product_simple_classified' => 'Product type can be either simple or classified',
    'license_type' => 'License type can be either auto_generate or select_license',
    'stock_status' => 'Stock status can be either in_stock or out_of_stock',
    'video_provider' => 'Video Provider can in youtube or vimeo or daily_motion',
    'sku_already_taken' => 'The SKU ":input" has already been taken',
    'position_required' => 'The watermark position field is required when watermark is true.',
    'variations_between' => 'Enter Variations discount between 0 to 99.99',
    'variations_stock_status' => 'Variations Stock status can be either in_stock or out_of_stock or coming_soon',
    'is_licensable_required' => 'The variations is_licensable field is required when product type is digital.',
    'is_licensekey_auto_required' => 'The variations is_licensekey_auto field is required when variations is_licensable is true.',
    'variation_separator_required' => 'The variations separator field is required when variations is_licensable is true.',
    'license_key_required' => 'The variations license_key field is required when variations is_licensable is true and is license key auto is false.',
    'payment_type' => 'Payment type should be paypal or bank  or wallet',
    'shipping_type' => 'Shipping type can be free or fixed or percentage',
    'shipping_rule' => 'Shipping Rule type can be either base_on_price or base_on_weight',
    'tag_type' => 'Tag type can be either post or product',
    'tax_rate' => 'Specify a tax rate between 0 and 99.99.',
    'payment_type_paypal_bank' => 'Payment type should be paypal or bank',
    'reaction_type' => 'Reaction can be liked or disliked.',
    'variation_between_input' => 'Enter Variations :input discount between 0 to 99.99',
    'refund_status' => 'Refund Status can be pending, approved or rejected',
    'tax_rate_required' => 'Enter Tax Rate between 0 to 99.99',
    'no_whitespace_host_name' => 'There should be no whitespace in host name',
    'no_whitespace_port_number' => 'There should be no whitespace in port number',
    'no_whitespace_username' => 'There should be no whitespace in username',
    'no_whitespace_database' => 'There should be no whitespace in database name',
    'name_already_taken' => 'The name has already been taken.',
    'category_id_required' => 'category parent id is not exists',
    'status_field_required' => 'status field is required',
    'name_field_required' => 'The name field is required.',
    'name_must_be_string' => 'The name must be a string.',
    'name_not_exceed' => 'The name must not exceed 255 characters.',
    'description_field_required' => 'The description field is required.',
    'description_must_be_string' => 'The description must be a string.',
    'description_length' => 'The description must be at least 10 characters.',
    'short_description_field_required' => 'The short description field is required.',
    'type_field_required' => 'The type field is required.',
    'simple_product_price_required' => 'The price field is required for a simple product type.',
    'price_must_be_number' => 'The price must be a number.',
    'simple_product_stock_status_required' => 'The stock status field is required for a simple product type',
    'valid_stock_status_required' => 'The stock status must be either in_stock or out_of_stock.',
    'simple_product_quantity_required' => 'The quantity field is required for a simple type.',
    'simple_product_sku_required' => 'The SKU field is required for a simple type.',
    'sku_is_already_taken' => 'The SKU has already been taken.',
    'discount_must_be_number' => 'The discount must be a number',
    'discount_must_be_correct_format' => 'The discount must be in the correct format.',
    'show_stock_quantity_min' => 'The show stock quantity must be 0 or 1.',
    'show_stock_quantity_max' => 'The show stock quantity must be 0 or 1.',
    'feature_field_min' => 'The is featured field must be 0 or 1.',
    'feature_field_max' => 'The is featured field must be 0 or 1.',
    'secure_checkout_min' => 'The secure checkout field must be 0 or 1.',
    'secure_checkout_min' => 'The secure checkout field must be 0 or 1.',
    'safe_checkout_field_min' => 'The safe checkout field must be 0 or 1.',
    'safe_checkout_field_max' => 'The safe checkout field must be 0 or 1.',
    'social_share_field_min' => 'The social share field must be 0 or 1.',
    'social_share_field_max' => 'The social share field must be 0 or 1.',
    'encourage_order_field_min' => 'The encourage order field must be 0 or 1.',
    'encourage_order_field_max' => 'The encourage order field must be 0 or 1.',
    'encourage_view_field_min' => 'The encourage view field must be 0 or 1.',
    'encourage_view_field_max' => 'The encourage view field must be 0 or 1.',
    'cod_field_min' => 'The is COD field must be 0 or 1.',
    'cod_field_max' => 'The is COD field must be 0 or 1.',
    'return_field_min' => 'The is return field must be 0 or 1.',
    'return_field_max' => 'The is return field must be 0 or 1.',
    'free_shipping_field_min' => 'The is free shipping field must be 0 or 1.',
    'free_shipping_field_max' => 'The is free shipping field must be 0 or 1.',
    'changeable_field_min' => 'The is changeable field must be 0 or 1.',
    'changeable_field_max' => 'The is changeable field must be 0 or 1.',
    'sale_enable_field_min' => 'The is sale enable field must be 0 or 1.',
    'sale_enable_field_max' => 'The is sale enable field must be 0 or 1.',
    'sale_starts_date_invalid' => 'The sale starts at must be a valid date.',
    'selected_store_invalid' => 'The selected store is invalid.',
    'sale_expire_date_invalid' => 'The sale expired at must be a valid date.',
    'sale_expire_date_after_start_date' => 'The sale expired date must be after the sale start date.',
    'status_field_required' => 'The status field is required.',
    'status_field_min' => 'The status field must be either 0 or 1.',
    'status_field_max' => 'The status field must be either 0 or 1.',
    'visible_time_invalid' => 'The visible time must be a valid date.',
    'variations_for_classified_required' => 'Variations are required for a classified type.',
    'email_field_required' => 'email field is required',
    'email_already_taken' => 'email has already been taken.',
    'phone_field_required' => 'phone field is required',
    'phone_already_taken' => 'phone has already been taken.',
    'phone_digits_between' => 'phone digits between 9 to 15.',
    'password_field_required' => 'password field is required.',

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | Here you may specify custom validation messages for attributes using the
    | convention "attribute.rule" to name the lines. This makes it quick to
    | specify a specific custom language line for a given attribute rule.
    |
    */

    'custom' => [
        'attribute-name' => [
            'rule-name' => 'custom-message',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Attributes
    |--------------------------------------------------------------------------
    |
    | The following language lines are used to swap our attribute placeholder
    | with something more reader friendly such as "E-Mail Address" instead
    | of "email". This simply helps us make our message more expressive.
    |
    */

    'attributes' => [],

];
