import { Routes } from '@angular/router';

import { ScrollPositionGuard } from './core/guard/scroll.guard';
import { content } from './shared/routes/routes';

export const routes: Routes = [
  {
    path: '',
    redirectTo: '',
    pathMatch: 'full',
  },
  {
    path: 'maintenance',
    loadComponent: () => import('./components/maintenance/maintenance').then(m => m.Maintenance),
  },
  {
    path: '',
    loadComponent: () => import('./layout/layout').then(m => m.Layout),
    children: content,
    canActivate: [ScrollPositionGuard],
  },
];
