import { CommonModule } from '@angular/common';
import { Component, inject } from '@angular/core';
import { Router, RouterModule } from '@angular/router';

import { TranslateModule } from '@ngx-translate/core';
import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { Sidebar } from './sidebar/sidebar';
import { GetNotificationAction } from '../../shared/action/notification.action';
import { Breadcrumb } from '../../shared/components/widgets/breadcrumb/breadcrumb';
import { Button } from '../../shared/components/widgets/button/button';
import { Loader } from '../../shared/components/widgets/loader/loader';
import { IBreadcrumb } from '../../shared/interface/breadcrumb';
import { LoaderState } from '../../shared/state/loader.state';

@Component({
  selector: 'app-account',
  imports: [CommonModule, TranslateModule, RouterModule, Breadcrumb, Sidebar, Loader, Button],
  templateUrl: './account.html',
  styleUrl: './account.scss',
})
export class Account {
  private router = inject(Router);
  private store = inject(Store);

  loadingStatus$: Observable<boolean> = inject(Store).select(
    LoaderState.status,
  ) as Observable<boolean>;

  public open: boolean = false;
  public breadcrumb: IBreadcrumb = {
    title: 'Dashboard',
    items: [{ label: 'Dashboard', active: false }],
  };

  constructor() {
    this.store.dispatch(new GetNotificationAction());

    this.breadcrumb.title = this.router?.url?.split('?')[0]?.split('/')?.pop()!;
    if (this.router?.url.includes('order/details')) {
      this.breadcrumb.title = 'Order';
    }
    this.breadcrumb.items = [];
    this.breadcrumb.items.push({ label: this.breadcrumb.title, active: false });
  }

  openMenu(value: boolean) {
    this.open = value;
  }
}
