import { CommonModule } from '@angular/common';
import { Component, inject, viewChild } from '@angular/core';

import { TranslateModule } from '@ngx-translate/core';
import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { DeleteAddressAction } from '../../../shared/action/account.action';
import { Button } from '../../../shared/components/widgets/button/button';
import { AddressModal } from '../../../shared/components/widgets/modal/address-modal/address-modal';
import { DeleteModal } from '../../../shared/components/widgets/modal/delete-modal/delete-modal';
import { NoData } from '../../../shared/components/widgets/no-data/no-data';
import { IAccountUser } from '../../../shared/interface/account.interface';
import { IUserAddress } from '../../../shared/interface/user.interface';
import { TitleCasePipe } from '../../../shared/pipe/title-case.pipe';
import { AccountState } from '../../../shared/state/account.state';

@Component({
  selector: 'app-addresses',
  imports: [
    CommonModule,
    TranslateModule,
    TitleCasePipe,
    Button,
    NoData,
    AddressModal,
    DeleteModal,
  ],
  templateUrl: './addresses.html',
  styleUrl: './addresses.scss',
})
export class Addresses {
  private store = inject(Store);

  user$: Observable<IAccountUser> = inject(Store).select(
    AccountState.user,
  ) as Observable<IAccountUser>;

  readonly AddressModal = viewChild<AddressModal>('addressModal');
  readonly DeleteModal = viewChild<DeleteModal>('deleteModal');

  delete(action: string, data: IUserAddress) {
    if (action == 'delete' && data) this.store.dispatch(new DeleteAddressAction(data.id));
  }
}
