import { CommonModule } from '@angular/common';
import { Component, inject, viewChild } from '@angular/core';

import { TranslateModule } from '@ngx-translate/core';
import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { ChangePasswordModal } from '../../../shared/components/widgets/modal/change-password-modal/change-password-modal';
import { EditProfileModal } from '../../../shared/components/widgets/modal/edit-profile-modal/edit-profile-modal';
import { IUser, IUserAddress } from '../../../shared/interface/user.interface';
import { CurrencySymbolPipe } from '../../../shared/pipe/currency-symbol.pipe';
import { TitleCasePipe } from '../../../shared/pipe/title-case.pipe';
import { AccountState } from '../../../shared/state/account.state';

@Component({
  selector: 'app-dashboard',
  imports: [
    CommonModule,
    TranslateModule,
    CurrencySymbolPipe,
    TitleCasePipe,
    EditProfileModal,
    ChangePasswordModal,
  ],
  templateUrl: './dashboard.html',
  styleUrl: './dashboard.scss',
})
export class Dashboard {
  user$: Observable<IUser> = inject(Store).select(AccountState.user) as Observable<IUser>;

  readonly ProfileModal = viewChild<EditProfileModal>('profileModal');
  readonly PasswordModal = viewChild<ChangePasswordModal>('passwordModal');

  public address: IUserAddress | null;

  constructor() {
    this.user$.subscribe(user => {
      this.address = user?.address?.length ? user?.address?.[0] : null;
    });
  }
}
