import { CommonModule } from '@angular/common';
import { Component, inject } from '@angular/core';

import { TranslateModule } from '@ngx-translate/core';
import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { MarkAsReadNotificationAction } from '../../../shared/action/notification.action';
import { NoData } from '../../../shared/components/widgets/no-data/no-data';
import { INotification } from '../../../shared/interface/notification.interface';
import { NotificationState } from '../../../shared/state/notification.state';

@Component({
  selector: 'app-notification',
  imports: [CommonModule, TranslateModule, NoData],
  templateUrl: './notification.html',
  styleUrl: './notification.scss',
})
export class Notification {
  private store = inject(Store);

  notification$: Observable<INotification[]> = inject(Store).select(
    NotificationState.notification,
  ) as Observable<INotification[]>;

  ngOnDestroy() {
    this.store.dispatch(new MarkAsReadNotificationAction());
  }
}
