import { CommonModule } from '@angular/common';
import { Component, inject } from '@angular/core';
import { RouterModule } from '@angular/router';

import { TranslateModule } from '@ngx-translate/core';
import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { GetOrdersAction } from '../../../shared/action/order.action';
import { NoData } from '../../../shared/components/widgets/no-data/no-data';
import { Pagination } from '../../../shared/components/widgets/pagination/pagination';
import { Params } from '../../../shared/interface/core.interface';
import { IOrderModel } from '../../../shared/interface/order.interface';
import { CurrencySymbolPipe } from '../../../shared/pipe/currency-symbol.pipe';
import { TitleCasePipe } from '../../../shared/pipe/title-case.pipe';
import { OrderState } from '../../../shared/state/order.state';

@Component({
  selector: 'app-orders',
  imports: [
    CommonModule,
    TranslateModule,
    RouterModule,
    CurrencySymbolPipe,
    TitleCasePipe,
    Pagination,
    NoData,
  ],
  templateUrl: './orders.html',
  styleUrl: './orders.scss',
})
export class Orders {
  private store = inject(Store);

  order$: Observable<IOrderModel> = inject(Store).select(
    OrderState.order,
  ) as Observable<IOrderModel>;

  public filter: Params = {
    page: 1, // Current page number
    paginate: 10, // Display per page,
  };

  constructor() {
    this.store.dispatch(new GetOrdersAction(this.filter));
  }

  setPaginate(page: number) {
    this.filter['page'] = page;
    this.store.dispatch(new GetOrdersAction(this.filter));
  }
}
