import { CommonModule } from '@angular/common';
import { Component, inject } from '@angular/core';

import { TranslateModule } from '@ngx-translate/core';
import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { GetUserTransactionAction } from '../../../shared/action/point.action';
import { NoData } from '../../../shared/components/widgets/no-data/no-data';
import { Pagination } from '../../../shared/components/widgets/pagination/pagination';
import { Params } from '../../../shared/interface/core.interface';
import { IPoint } from '../../../shared/interface/point.interface';
import { IValues } from '../../../shared/interface/setting.interface';
import { CurrencySymbolPipe } from '../../../shared/pipe/currency-symbol.pipe';
import { TitleCasePipe } from '../../../shared/pipe/title-case.pipe';
import { PointState } from '../../../shared/state/point.state';
import { SettingState } from '../../../shared/state/setting.state';

@Component({
  selector: 'app-point',
  imports: [CommonModule, TranslateModule, CurrencySymbolPipe, TitleCasePipe, Pagination, NoData],
  templateUrl: './point.html',
  styleUrl: './point.scss',
})
export class Point {
  private store = inject(Store);

  setting$: Observable<IValues> = inject(Store).select(SettingState.setting) as Observable<IValues>;
  point$: Observable<IPoint> = inject(Store).select(PointState.point) as Observable<IPoint>;

  public filter: Params = {
    page: 1, // Current page number
    paginate: 10, // Display per page,
  };

  constructor() {
    this.store.dispatch(new GetUserTransactionAction(this.filter));
  }

  setPaginate(page: number) {
    this.filter['page'] = page;
    this.store.dispatch(new GetUserTransactionAction(this.filter));
  }
}
