import { CommonModule } from '@angular/common';
import { Component, inject } from '@angular/core';

import { TranslateModule } from '@ngx-translate/core';
import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { GetRefundAction } from '../../../shared/action/refund.action';
import { NoData } from '../../../shared/components/widgets/no-data/no-data';
import { Pagination } from '../../../shared/components/widgets/pagination/pagination';
import { Params } from '../../../shared/interface/core.interface';
import { IRefundModel } from '../../../shared/interface/refund.interface';
import { TitleCasePipe } from '../../../shared/pipe/title-case.pipe';
import { RefundState } from '../../../shared/state/refund.state';

@Component({
  selector: 'app-refund',
  imports: [CommonModule, TranslateModule, TitleCasePipe, Pagination, NoData],
  templateUrl: './refund.html',
  styleUrl: './refund.scss',
})
export class Refund {
  private store = inject(Store);

  refund$: Observable<IRefundModel> = inject(Store).select(
    RefundState.refund,
  ) as Observable<IRefundModel>;

  public filter: Params = {
    page: 1, // Current page number
    paginate: 10, // Display per page,
  };

  constructor() {
    this.store.dispatch(new GetRefundAction(this.filter));
  }

  setPaginate(page: number) {
    this.filter['page'] = page;
    this.store.dispatch(new GetRefundAction(this.filter));
  }
}
