import { CommonModule } from '@angular/common';
import { Component, inject } from '@angular/core';

import { TranslateModule } from '@ngx-translate/core';
import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { GetUserTransactionAction } from '../../../shared/action/wallet.action';
import { NoData } from '../../../shared/components/widgets/no-data/no-data';
import { Pagination } from '../../../shared/components/widgets/pagination/pagination';
import { Params } from '../../../shared/interface/core.interface';
import { IWallet } from '../../../shared/interface/wallet.interface';
import { CurrencySymbolPipe } from '../../../shared/pipe/currency-symbol.pipe';
import { TitleCasePipe } from '../../../shared/pipe/title-case.pipe';
import { WalletState } from '../../../shared/state/wallet.state';

@Component({
  selector: 'app-wallet',
  imports: [CommonModule, TranslateModule, CurrencySymbolPipe, TitleCasePipe, Pagination, NoData],
  templateUrl: './wallet.html',
  styleUrl: './wallet.scss',
})
export class Wallet {
  private store = inject(Store);

  wallet$: Observable<IWallet> = inject(Store).select(WalletState.wallet) as Observable<IWallet>;

  public filter: Params = {
    page: 1, // Current page number
    paginate: 10, // Display per page,
  };

  constructor() {
    this.store.dispatch(new GetUserTransactionAction(this.filter));
  }

  setPaginate(page: number) {
    this.filter['page'] = page;
    this.store.dispatch(new GetUserTransactionAction(this.filter));
  }
}
