import { Routes } from '@angular/router';

export const authRoutes: Routes = [
  {
    path: 'login',
    loadComponent: () => import('./login/login').then(m => m.Login),
  },
  {
    path: 'forgot-password',
    loadComponent: () => import('./forgot-password/forgot-password').then(m => m.ForgotPassword),
  },
  {
    path: 'otp',
    loadComponent: () => import('./otp/otp').then(m => m.Otp),
  },
  {
    path: 'update-password',
    loadComponent: () => import('./update-password/update-password').then(m => m.UpdatePassword),
  },
  {
    path: 'register',
    loadComponent: () => import('./register/register').then(m => m.Register),
  },
  {
    path: 'login-with-number',
    loadComponent: () =>
      import('./login-with-number/login-with-number').then(m => m.LoginWithNumber),
  },
];
