import { CommonModule } from '@angular/common';
import { Component, inject } from '@angular/core';
import { ActivatedRoute } from '@angular/router';

import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { Breadcrumb } from '../../../shared/components/widgets/breadcrumb/breadcrumb';
import { IBlog } from '../../../shared/interface/blog.interface';
import { IBreadcrumb } from '../../../shared/interface/breadcrumb';
import { IOption } from '../../../shared/interface/theme-option.interface';
import { BlogState } from '../../../shared/state/blog.state';
import { ThemeOptionState } from '../../../shared/state/theme-option.state';
import { BlogSidebar } from '../sidebar/sidebar';

@Component({
  selector: 'app-blog-details',
  imports: [CommonModule, Breadcrumb, BlogSidebar],
  templateUrl: './blog-details.html',
  styleUrl: './blog-details.scss',
})
export class BlogDetails {
  private route = inject(ActivatedRoute);

  blog$: Observable<IBlog> = inject(Store).select(BlogState.selectedBlog) as Observable<IBlog>;
  themeOption$: Observable<IOption> = inject(Store).select(
    ThemeOptionState.themeOptions,
  ) as Observable<IOption>;

  public breadcrumb: IBreadcrumb = {
    title: 'Product',
    items: [],
  };

  public sidebar: string;

  constructor() {
    this.blog$.subscribe(blog => {
      this.breadcrumb.items = [];
      this.breadcrumb.title = blog.title;
      this.breadcrumb.items.push(
        { label: 'Blog', active: true },
        { label: blog.title, active: false },
      );
    });

    // For Demo Purpose only
    this.route.queryParams.subscribe(params => {
      if (params['sidebar']) {
        this.sidebar = params['sidebar'];
      } else {
        // Get Blog Layout
        this.themeOption$.subscribe(theme => {
          this.sidebar = theme?.blog.blog_sidebar_type;
        });
      }
    });
  }
}
