import { CommonModule } from '@angular/common';
import { Component, inject } from '@angular/core';

import { NgbModule } from '@ng-bootstrap/ng-bootstrap';
import { TranslateModule } from '@ngx-translate/core';
import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { GetRecentBlogAction } from '../../../shared/action/blog.action';
import { GetTagsAction } from '../../../shared/action/tag.action';
import { IBlog } from '../../../shared/interface/blog.interface';
import { ICategoryModel } from '../../../shared/interface/category.interface';
import { ITagModel } from '../../../shared/interface/tag.interface';
import { BlogService } from '../../../shared/services/blog.service';
import { BlogState } from '../../../shared/state/blog.state';
import { CategoryState } from '../../../shared/state/category.state';
import { TagState } from '../../../shared/state/tag.state';
import { SkeletonBlog } from '../skeleton-blog/skeleton-blog';
import { BlogCategory } from './blog-category/blog-category';
import { BlogTag } from './blog-tag/blog-tag';
import { RecentPost } from './recent-post/recent-post';

@Component({
  selector: 'app-blog-sidebar',
  imports: [
    CommonModule,
    TranslateModule,
    NgbModule,
    SkeletonBlog,
    RecentPost,
    BlogCategory,
    BlogTag,
  ],
  templateUrl: './sidebar.html',
  styleUrl: './sidebar.scss',
})
export class BlogSidebar {
  private store = inject(Store);
  public blogService = inject(BlogService);

  resentBlog$: Observable<IBlog[]> = inject(Store).select(BlogState.resentBlog) as Observable<
    IBlog[]
  >;
  tag$: Observable<ITagModel> = inject(Store).select(TagState.tag) as Observable<ITagModel>;
  category$: Observable<ICategoryModel> = inject(Store).select(
    CategoryState.category,
  ) as Observable<ICategoryModel>;

  constructor() {
    this.store.dispatch(new GetTagsAction({ status: 1, type: 'post' }));
    this.store.dispatch(new GetRecentBlogAction({ status: 1, type: 'post', paginate: '5' }));
  }
}
