import { AsyncPipe, NgStyle } from '@angular/common';
import { Component, inject } from '@angular/core';

import { Store } from '@ngxs/store';
import { Observable } from 'rxjs';

import { GetSettingOptionAction } from '../../shared/action/setting.action';
import { IValues } from '../../shared/interface/setting.interface';
import { SettingState } from '../../shared/state/setting.state';

@Component({
  selector: 'app-maintenance',
  templateUrl: './maintenance.html',
  styleUrls: ['./maintenance.scss'],
  imports: [NgStyle, AsyncPipe],
})
export class Maintenance {
  private store = inject(Store);

  setting$: Observable<IValues> = inject(Store).select(SettingState.setting) as Observable<IValues>;

  constructor() {
    this.store.dispatch(new GetSettingOptionAction());
  }
}
